<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

?>
<div class="newsx-free-vs-pro-wrap">
    <div class="newsx-section-header">
        <h2><?php esc_html_e('Free vs Pro Features', 'news-magazine-x'); ?></h2>

        <div class="newsx-action-buttons">
            <a href="<?php echo esc_url('https://news-magazine-x-pro.wp-royal-themes.com/test-drive-demo/wp-content/plugins/open-house-theme-options/redirect.php?multisite=test-drive-demo'); ?>" target="_blank" class="button button-primary">
                <?php esc_html_e('Try Before Buy ➝', 'news-magazine-x'); ?>
            </a>
            <a href="<?php echo esc_url('https://wp-royal-themes.com/themes/item-news-magazine-x-pro/?ref=newsx-free-dash-freevspro-upgrade-pro#features'); ?>" target="_blank" class="button button-primary">
                <?php esc_html_e('Upgrade to Pro', 'news-magazine-x'); ?>
            </a>
        </div>
    </div>

    <table class="newsx-free-vs-pro">
        <thead>
            <tr>
                <th><?php esc_html_e('Features', 'news-magazine-x'); ?></th>
                <th><?php esc_html_e('Free', 'news-magazine-x'); ?></th>
                <th><?php esc_html_e('Pro', 'news-magazine-x'); ?></th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>
                    <h3 class="feature-title"><?php esc_html_e('24/7 Premium Support', 'news-magazine-x'); ?></h3>
                    <p class="feature-description"><?php esc_html_e('Get premium customer support 24/7 with our dedicated team.', 'news-magazine-x'); ?></p>
                </td>
                <td><span class="dashicons dashicons-no-alt"></span></td>
                <td><span class="dashicons dashicons-yes-alt"></span></td>
            </tr>
            <tr>
                <td>
                    <h3 class="feature-title"><?php esc_html_e('Access To Pro Updates', 'news-magazine-x'); ?></h3>
                    <p class="feature-description"><?php esc_html_e('Get instant access to the latest pro features and updates.', 'news-magazine-x'); ?></p>
                </td>
                <td><span class="dashicons dashicons-no-alt"></span></td>
                <td><span class="dashicons dashicons-yes-alt"></span></td>
            </tr>
            <tr>
                <td>
                    <h3 class="feature-title"><?php esc_html_e('Colors and Backgrounds', 'news-magazine-x'); ?></h3>
                    <p class="feature-description"><?php esc_html_e('Advanced color and background customization options.', 'news-magazine-x'); ?></p>
                </td>
                <td><?php esc_html_e('Limited Features', 'news-magazine-x'); ?></td>
                <td><?php esc_html_e('All Features', 'news-magazine-x'); ?></td>
            </tr>
            <tr>
                <td>
                    <h3 class="feature-title"><?php esc_html_e('Typography', 'news-magazine-x'); ?></h3>
                    <p class="feature-description"><?php esc_html_e('1000+ Google Fonts. Advanced typography options and customization.', 'news-magazine-x'); ?></p>
                </td>
                <td><?php esc_html_e('Limited Features', 'news-magazine-x'); ?></td>
                <td><?php esc_html_e('All Features', 'news-magazine-x'); ?></td>
            </tr>
            <tr>
                <td>
                    <h3 class="feature-title"><?php esc_html_e('Sticky Header', 'news-magazine-x'); ?></h3>
                    <p class="feature-description"><?php esc_html_e('Custom Sticky options for Top, Middle and Bottom sections of the header.', 'news-magazine-x'); ?></p>
                </td>
                <td><span class="dashicons dashicons-no-alt"></span></td>
                <td><span class="dashicons dashicons-yes-alt"></span></td>
            </tr>
            <tr>
                <td>
                    <h3 class="feature-title"><?php esc_html_e('Header: Advertisement Banner', 'news-magazine-x'); ?></h3>
                    <p class="feature-description"><?php esc_html_e('Add an ad banner to the header with Custom HTML or Header Widget Areas.', 'news-magazine-x'); ?></p>
                </td>
                <td><span class="dashicons dashicons-no-alt"></span></td>
                <td><span class="dashicons dashicons-yes-alt"></span></td>
            </tr>
            <tr>
                <td>
                    <h3 class="feature-title"><?php esc_html_e('Header: Weather Forecast Widget', 'news-magazine-x'); ?></h3>
                    <p class="feature-description"><?php esc_html_e('Add a weather forecast widget with auto location detection to the header.', 'news-magazine-x'); ?></p>
                </td>
                <td><span class="dashicons dashicons-no-alt"></span></td>
                <td><span class="dashicons dashicons-yes-alt"></span></td>
            </tr>
            <tr>
                <td>
                    <h3 class="feature-title"><?php esc_html_e('Header: Search Form (AJAX)', 'news-magazine-x'); ?></h3>
                    <p class="feature-description"><?php esc_html_e('Enable AJAX search in the header search form. Choose from 3 different search styles.', 'news-magazine-x'); ?></p>
                </td>
                <td><?php esc_html_e('Classic Search', 'news-magazine-x'); ?></td>
                <td><?php esc_html_e('AJAX Search', 'news-magazine-x'); ?></td>
            </tr>
            <tr>
                <td>
                    <h3 class="feature-title"><?php esc_html_e('Header: Call To Action Button', 'news-magazine-x'); ?></h3>
                    <p class="feature-description"><?php esc_html_e('Add a call to action button to the header with a custom link.', 'news-magazine-x'); ?></p>
                </td>
                <td><span class="dashicons dashicons-no-alt"></span></td>
                <td><span class="dashicons dashicons-yes-alt"></span></td>
            </tr>
            <tr>
                <td>
                    <h3 class="feature-title"><?php esc_html_e('Front Page Sections', 'news-magazine-x'); ?></h3>
                    <p class="feature-description"><?php esc_html_e('Add up to 10 sections, Choose from 4 different Layouts, stretch sections to full width.', 'news-magazine-x'); ?></p>
                </td>
                <td><?php esc_html_e('3 Sections', 'news-magazine-x'); ?></td>
                <td><?php esc_html_e('10 Sections', 'news-magazine-x'); ?></td>
            </tr>
            <tr>
                <td>
                    <h3 class="feature-title"><?php esc_html_e('Magazine Grid Widget Layouts', 'news-magazine-x'); ?></h3>
                    <p class="feature-description"><?php esc_html_e('Display your posts in a grid layout with up to 12 different layouts.', 'news-magazine-x'); ?></p>
                </td>
                <td><?php esc_html_e('2', 'news-magazine-x'); ?></td>
                <td><?php esc_html_e('12', 'news-magazine-x'); ?></td>
            </tr>
            <tr>
                <td>
                    <h3 class="feature-title"><?php esc_html_e('Magazine List Widget Layouts', 'news-magazine-x'); ?></h3>
                    <p class="feature-description"><?php esc_html_e('Display your posts in a list layout with up to 9 different layouts.', 'news-magazine-x'); ?></p>
                </td>
                <td><?php esc_html_e('3', 'news-magazine-x'); ?></td>
                <td><?php esc_html_e('9', 'news-magazine-x'); ?></td>
            </tr>
            <tr>
                <td>
                    <h3 class="feature-title"><?php esc_html_e('Posts Grid Widget Layouts', 'news-magazine-x'); ?></h3>
                    <p class="feature-description"><?php esc_html_e('Display your posts in a grid layout with 1, 2, 3 or 4 columns.', 'news-magazine-x'); ?></p>
                </td>
                <td><?php esc_html_e('1', 'news-magazine-x'); ?></td>
                <td><?php esc_html_e('4', 'news-magazine-x'); ?></td>
            </tr>
            <tr>
                <td>
                    <h3 class="feature-title"><?php esc_html_e('Posts Slider / Carousel Widget', 'news-magazine-x'); ?></h3>
                    <p class="feature-description"><?php esc_html_e('Display your posts in a slider or carousel (2, 3, 4 Columns).', 'news-magazine-x'); ?></p>
                </td>
                <td><span class="dashicons dashicons-no-alt"></span></td>
                <td><span class="dashicons dashicons-yes-alt"></span></td>
            </tr>
            <tr>
                <td>
                    <h3 class="feature-title"><?php esc_html_e('Weather Forecast Widget', 'news-magazine-x'); ?></h3>
                    <p class="feature-description"><?php esc_html_e('Display a weather forecast widget with auto location detection. ', 'news-magazine-x'); ?></p>
                </td>
                <td><span class="dashicons dashicons-no-alt"></span></td>
                <td><span class="dashicons dashicons-yes-alt"></span></td>
            </tr>
            <tr>
                <td>
                    <h3 class="feature-title"><?php esc_html_e('Video Playlist Widget', 'news-magazine-x'); ?></h3>
                    <p class="feature-description"><?php esc_html_e('Display a video playlist widget with a up to 6 custom video URLs.', 'news-magazine-x'); ?></p>
                </td>
                <td><span class="dashicons dashicons-no-alt"></span></td>
                <td><span class="dashicons dashicons-yes-alt"></span></td>
            </tr>
            <tr>
                <td>
                    <h3 class="feature-title"><?php esc_html_e('Single Post Layouts', 'news-magazine-x'); ?></h3>
                    <p class="feature-description"><?php esc_html_e('Choose from 8 different styles of single post layouts.', 'news-magazine-x'); ?></p>
                </td>
                <td><?php esc_html_e('1', 'news-magazine-x'); ?></td>
                <td><?php esc_html_e('8', 'news-magazine-x'); ?></td>
            </tr>
            <tr>
                <td>
                    <h3 class="feature-title"><?php esc_html_e('Single Post: Table of Contents', 'news-magazine-x'); ?></h3>
                    <p class="feature-description"><?php esc_html_e('Add a table of contents to the single post content.', 'news-magazine-x'); ?></p>
                </td>
                <td><span class="dashicons dashicons-no-alt"></span></td>
                <td><span class="dashicons dashicons-yes-alt"></span></td>
            </tr>
            <tr>
                <td>
                    <h3 class="feature-title"><?php esc_html_e('Single Post: Reading Time and Post Views', 'news-magazine-x'); ?></h3>
                    <p class="feature-description"><?php esc_html_e('Add a reading time and post views to the single post header.', 'news-magazine-x'); ?></p>
                </td>
                <td><span class="dashicons dashicons-no-alt"></span></td>
                <td><span class="dashicons dashicons-yes-alt"></span></td>
            </tr>
            <tr>
                <td>
                    <h3 class="feature-title"><?php esc_html_e('Single Post: Reading Progress Bar', 'news-magazine-x'); ?></h3>
                    <p class="feature-description"><?php esc_html_e('Add a reading progress bar to the single posts.', 'news-magazine-x'); ?></p>
                </td>
                <td><span class="dashicons dashicons-no-alt"></span></td>
                <td><span class="dashicons dashicons-yes-alt"></span></td>
            </tr>
            <tr>
                <td>
                    <h3 class="feature-title"><?php esc_html_e('Single Post: Auto Load Next Post', 'news-magazine-x'); ?></h3>
                    <p class="feature-description"><?php esc_html_e('Add a auto load next post at the end of the single post on scroll.', 'news-magazine-x'); ?></p>
                </td>
                <td><span class="dashicons dashicons-no-alt"></span></td>
                <td><span class="dashicons dashicons-yes-alt"></span></td>
            </tr>
            <tr>
                <td>
                    <h3 class="feature-title"><?php esc_html_e('Single Post: Navigation Layouts', 'news-magazine-x'); ?></h3>
                    <p class="feature-description"><?php esc_html_e('Choose from 8 different layouts for the single post navigation.', 'news-magazine-x'); ?></p>
                </td>
                <td><?php esc_html_e('1', 'news-magazine-x'); ?></td>
                <td><?php esc_html_e('8', 'news-magazine-x'); ?></td>
            </tr>
            <tr>
                <td>
                    <h3 class="feature-title"><?php esc_html_e('Single Post: Social Sharing', 'news-magazine-x'); ?></h3>
                    <p class="feature-description"><?php esc_html_e('Display social sharing buttons in post header and/or as a floating sharing bar.', 'news-magazine-x'); ?></p>
                </td>
                <td><?php esc_html_e('1 Location', 'news-magazine-x'); ?></td>
                <td><?php esc_html_e('3 Locations', 'news-magazine-x'); ?></td>
            </tr>
            <tr>
                <td>
                    <h3 class="feature-title"><?php esc_html_e('Post Formats Support', 'news-magazine-x'); ?></h3>
                    <p class="feature-description"><?php esc_html_e('Create Audio, Video, Gallery Blog Posts with unique, modern and minimal styling. Full control over your Blog Posts.', 'news-magazine-x'); ?></p>
                </td>
                <td><span class="dashicons dashicons-no-alt"></span></td>
                <td><span class="dashicons dashicons-yes-alt"></span></td>
            </tr>
            <tr>
                <td>
                    <h3 class="feature-title"><?php esc_html_e('Custom Background Styling', 'news-magazine-x'); ?></h3>
                    <p class="feature-description"><?php esc_html_e('Customize Header, Footer, and Page Backgrounds with Background Color, Image, and Gradient.', 'news-magazine-x'); ?></p>
                </td>
                <td><span class="dashicons dashicons-no-alt"></span></td>
                <td><span class="dashicons dashicons-yes-alt"></span></td>
            </tr>
            <tr>
                <td>
                    <h3 class="feature-title"><?php esc_html_e('Sidebar Designing Styles', 'news-magazine-x'); ?></h3>
                    <p class="feature-description"><?php esc_html_e('Sticky Sidebar, Custom Sidebar Width, Left & Right Sidebar, No Sidebar, etc.', 'news-magazine-x'); ?></p>
                </td>
                <td><span class="dashicons dashicons-no-alt"></span></td>
                <td><span class="dashicons dashicons-yes-alt"></span></td>
            </tr>
            <tr>
                <td>
                    <h3 class="feature-title"><?php esc_html_e('Footer Widget Areas', 'news-magazine-x'); ?></h3>
                    <p class="feature-description"><?php esc_html_e('Add up to 6 widget areas to the footer.', 'news-magazine-x'); ?></p>
                </td>
                <td><?php esc_html_e('4', 'news-magazine-x'); ?></td>
                <td><?php esc_html_e('6', 'news-magazine-x'); ?></td>
            </tr>
            <tr>
                <td>
                    <h3 class="feature-title"><?php esc_html_e('Page Preloader', 'news-magazine-x'); ?></h3>
                    <p class="feature-description"><?php esc_html_e('Multiple animation styles and customizable settings for your page preloader.', 'news-magazine-x'); ?></p>
                </td>
                <td><span class="dashicons dashicons-no-alt"></span></td>
                <td><span class="dashicons dashicons-yes-alt"></span></td>
            </tr>
            <tr>
                <td>
                    <h3 class="feature-title"><?php esc_html_e('Access to PRO Starter Templates', 'news-magazine-x'); ?></h3>
                    <p class="feature-description"><?php esc_html_e('Includes the full collection of Premium Starter Templates', 'news-magazine-x'); ?></p>
                </td>
                <td><span class="dashicons dashicons-no-alt"></span></td>
                <td><span class="dashicons dashicons-yes-alt"></span></td>
            </tr>
            <tr>
                <td>
                    <h3 class="feature-title"><?php esc_html_e('Free Localhost / Staging / Test Licenses', 'news-magazine-x'); ?></h3>
                    <p class="feature-description"><?php esc_html_e('You can Activate the License on Staging/testing sites and this will not count as real activation.', 'news-magazine-x'); ?></p>
                </td>
                <td><span class="dashicons dashicons-no-alt"></span></td>
                <td><span class="dashicons dashicons-yes-alt"></span></td>
            </tr>
        </tbody>
    </table>

    <div class="newsx-action-buttons" style="margin-top: 2rem;">
            <a href="<?php echo esc_url('https://news-magazine-x-pro.wp-royal-themes.com/test-drive-demo/wp-content/plugins/open-house-theme-options/redirect.php?multisite=test-drive-demo'); ?>" target="_blank" class="button button-primary">
                <?php esc_html_e('Try Before Buy ➝', 'news-magazine-x'); ?>
            </a>
        <a href="<?php echo esc_url('https://wp-royal-themes.com/themes/item-news-magazine-x-pro/?ref=newsx-free-dash-freevspro-upgrade-pro#features'); ?>" target="_blank" class="button button-primary">
            <?php esc_html_e('Upgrade to Pro', 'news-magazine-x'); ?>
        </a>
    </div>
</div>